/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools;

import ch.dlcm.model.preingest.Deposit;
import ch.dlcm.tools.SshTransportConfigCallback;
import ch.dlcm.tools.common.DLCMTools;
import ch.dlcm.tools.config.GitConfig;
import ch.unige.solidify.exception.SolidifyRuntimeException;
import ch.unige.solidify.util.FileTool;
import ch.unige.solidify.util.StandaloneRestClientTool;
import ch.unige.solidify.util.StringTool;
import ch.unige.solidify.util.ZipTool;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"git"})
public class SourceCodeService
extends DLCMTools
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SourceCodeService.class);
    private static final String ORGUNIT_PREFIX = "[GIT] ";
    private GitConfig gitConfig;

    public SourceCodeService(StandaloneRestClientTool restClientTool, GitConfig gitConfig) {
        super(restClientTool);
        this.gitConfig = gitConfig;
    }

    public void run(String ... args) throws Exception {
        File workingDir = this.cloneGitRepository();
        FileTool.deleteFolder((Path)Paths.get(workingDir.getPath() + File.separatorChar + ".git", new String[0]));
        Path zipContainingCode = this.createZipAndUpload(workingDir);
        FileTool.deleteFolder((Path)workingDir.toPath());
        FileTool.deleteFile((Path)zipContainingCode);
    }

    private File cloneGitRepository() {
        File workingDir;
        SshTransportConfigCallback.SshWithPubKeyAndPassphrase transportConfigCallback = new SshTransportConfigCallback.SshWithPubKeyAndPassphrase(this.gitConfig.getSshPassphrase(), this.gitConfig.getPrivateKeyFile());
        log.info("Git configurations are : {}, {}", (Object)this.gitConfig.getRepositoryUrl(), (Object)this.gitConfig.getBranch());
        try {
            workingDir = Files.createTempDirectory("code-repository", new FileAttribute[0]).toFile();
            CloneCommand cloneCommand = ((CloneCommand)Git.cloneRepository().setDirectory(workingDir).setTransportConfigCallback((TransportConfigCallback)transportConfigCallback)).setURI(this.gitConfig.getRepositoryUrl());
            if (!StringTool.isNullOrEmpty((String)this.gitConfig.getBranch())) {
                cloneCommand.setBranchesToClone(Collections.singleton("refs/heads/" + this.gitConfig.getBranch())).setBranch("refs/heads/" + this.gitConfig.getBranch()).call();
            } else {
                Git git = ((CloneCommand)Git.cloneRepository().setURI(this.gitConfig.getRepositoryUrl()).setDirectory(workingDir).setTransportConfigCallback((TransportConfigCallback)transportConfigCallback)).setCloneAllBranches(true).call();
                if (!StringTool.isNullOrEmpty((String)this.gitConfig.getCommit())) {
                    git.checkout().setCreateBranch(true).setName("new-branch").setStartPoint(this.gitConfig.getCommit()).call();
                } else if (!StringTool.isNullOrEmpty((String)this.gitConfig.getTag())) {
                    git.checkout().setCreateBranch(true).setName("my-branch").setStartPoint("refs/tags/" + this.gitConfig.getTag()).call();
                }
            }
        }
        catch (IOException | GitAPIException e) {
            log.error("Error when trying to clone repository : {}", (Object)this.gitConfig.getRepositoryUrl());
            throw new SolidifyRuntimeException("Error when trying to clone repository.", e);
        }
        return workingDir;
    }

    private Path createZipAndUpload(File workingDir) throws IOException {
        String projectName = this.gitConfig.getRepositoryUrl().substring(this.gitConfig.getRepositoryUrl().lastIndexOf(47) + 1).replaceFirst("[.][^.]+$", "");
        Path zipContainingCode = Files.createTempFile(projectName, ".zip", new FileAttribute[0]);
        ZipTool zip = new ZipTool(zipContainingCode.toUri());
        boolean isZipFileGenerated = zip.zipFiles(workingDir.toPath());
        if (!isZipFileGenerated) {
            throw new SolidifyRuntimeException("Error when generating the Zip containing source code files");
        }
        String organizationUnitId = this.findOrganizationUnit(this.gitConfig.getOrganizationalUnit());
        if (organizationUnitId == null) {
            organizationUnitId = this.createOrganizationUnit(ORGUNIT_PREFIX, this.gitConfig.getOrganizationalUnit());
        }
        String nameOfDeposit = projectName + "-" + this.generateDepositName();
        Deposit deposit = this.sendDeposit("git", organizationUnitId, nameOfDeposit);
        this.addDataFile(this.preIngestUrl + "/deposits/" + deposit.getResId() + "/upload-archive", zipContainingCode, this.gitConfig.getDataCategory(), this.gitConfig.getDataSubCategory(), null, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return zipContainingCode;
    }

    private String generateDepositName() {
        StringBuilder name = new StringBuilder();
        if (!StringTool.isNullOrEmpty((String)this.gitConfig.getCommit())) {
            name.append(this.gitConfig.getCommit());
        } else if (!StringTool.isNullOrEmpty((String)this.gitConfig.getTag())) {
            name.append(this.gitConfig.getTag());
        } else if (!StringTool.isNullOrEmpty((String)this.gitConfig.getBranch())) {
            name.append(this.gitConfig.getBranch());
        } else {
            name.append("master");
        }
        return name.toString();
    }
}

