/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools;

import ch.unige.solidify.util.FileTool;
import ch.unige.solidify.util.ZipTool;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"zip"})
public class Zip
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(Zip.class);
    @Value(value="${dlcm.load}")
    private String loadFolder;

    public void run(String ... arg0) {
        String prefix = "[Zip]";
        if (!this.loadFolder.isEmpty()) {
            log.info("{} Scanning folder : {}", (Object)"[Zip]", (Object)this.loadFolder);
            int count = 0;
            for (Path folder : FileTool.scanFolder((Path)Paths.get(this.loadFolder, new String[0]), x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
                ++count;
                Instant start = Instant.now();
                Path zipFile = Paths.get(folder.toString() + ".zip", new String[0]);
                try {
                    ZipTool zipPackage = new ZipTool(zipFile.toUri());
                    if (!zipPackage.zipFiles(folder)) {
                        log.error("{} Zipping error {}", (Object)"[Zip]", (Object)folder);
                    }
                }
                catch (Exception e) {
                    log.error("{} Error in zipping {}", new Object[]{"[Zip]", folder, e});
                }
                Instant finish = Instant.now();
                log.info("{} Compression duration of {}: {}s", new Object[]{"[Zip]", folder, Duration.between(start, finish).getSeconds()});
            }
            log.info("{} Zip process of {} : {} processed file(s)", new Object[]{"[Zip]", this.loadFolder, count});
        }
    }
}

